#version 330

in vec3 fragPosition;
in vec2 fragTexCoord;
in vec3 fragNormal;
in vec4 shadowPos;

uniform vec4 colDiffuse;
uniform sampler2D texture0; // Diffuse
uniform sampler2D texture1; // Normal
uniform sampler2D texture2; // Specular

uniform sampler2D shadowMap;
uniform int shadowMapSize;

uniform vec3 lightPos;
uniform vec3 lightDir;
uniform float lightCutoff;
uniform vec3 viewPos;

out vec4 finalColor;

const float ambient = 0.5;
const float gamma = 2.5;

float ShadowCalc(vec4 p, float bias);

void main() {
    vec2 texelSize = 1.0 / vec2(shadowMapSize);
	vec3 lightRaw = lightPos - fragPosition;
	vec3 lightVec = normalize(lightRaw);

	vec3 lightDir = normalize(viewPos - fragPosition);
	vec3 h = normalize(lightVec + lightDir);

    vec3 normal = normalize(fragNormal);

	float NdL = max(0.0, dot(lightVec, normal));
	float NdH = max(0.0, dot(h, normal));

    float bias = max(0.0001 * (1.0 - dot(normal, lightDir)), 0.00001);

    float shadow = 0.0;
    if (shadowMapSize > 0) {
        shadow = ShadowCalc(shadowPos, bias);
    }


    // TODO: specular map
    float shine = colDiffuse.a;

    float diffuse;
    if (shine == 1.0) {
        diffuse = smoothstep(0.0, 0.05, NdL);
        shine = 0.3;
    } else {
        diffuse = NdL;
    }

	float spec = pow(NdH * diffuse, 256.0);
    spec = smoothstep(0.0, 0.01, spec);

    float rimIntensity = 1.0 - dot(lightDir, normal);
    vec3 rim = smoothstep(0.5, 0.55, vec3(rimIntensity * NdL));

    vec4 baseColor = colDiffuse;
    baseColor.a = 1.0;
    vec4 texColor = texture(texture0, fragTexCoord);

    vec4 color;

    if (texColor.a == 0.0) {
        color = baseColor;
    } else {
        color = texColor;
    }

    finalColor.rgb = (ambient + (1.0 - shadow) * diffuse) * (color.rgb) + (rim + spec) * shine;
        
    finalColor.rgb = pow(finalColor.rgb, vec3(1.0 / gamma));
    finalColor.a = color.a;
}

float ShadowCalc(vec4 p, float bias)
{
    vec3 projCoords = p.xyz / p.w;
    projCoords = projCoords * 0.5 + 0.5;
    projCoords.z = projCoords.z - bias;
	float depth = projCoords.z;

    float shadow = 0.0;
    vec2 texelSize = 1.0 / vec2(shadowMapSize);
    for (int x = -1; x <= 1; ++x)
    {
        for (int y = -1; y <= 1; ++y)
        {
            float pcfDepth = texture(shadowMap, projCoords.xy + vec2(x, y) * texelSize).r; 
            shadow += (depth - bias > pcfDepth)  ? 1.0 : 0.0;        
        }    
    }
    shadow /= 9.0;

    
	if (projCoords.z > 1.0 || projCoords.x > 1.0 || projCoords.y > 1.0)
        shadow = 1.0;

    return shadow;
}
