#version 330

#define inner 0.8
#define outer 1.1
#define strength 1.0
#define curvature 0.2
#define addToLength -0.2

in vec2 fragTexCoord;

uniform float player1TimeSinceHit;
uniform float player2TimeSinceHit;

out vec4 finalColor;

void main()
{
	vec2 uv = fragTexCoord;
	
	float hitLeft = 1.0 - clamp(player1TimeSinceHit, 0.0, 1.0);
	float hitRight = 1.0 - clamp(player2TimeSinceHit, 0.0, 1.0);

    vec2 curve = pow(abs(uv*2.-1.),vec2(1./curvature));
    float edge = pow(length(curve),curvature);
    float vignette = strength*smoothstep(inner,outer,edge);

	vec4 color = vec4(1.0, 0.3, 0.3, 1.0) * vignette;

	float leftX = smoothstep(0.0, 1.0, uv.x);
	float rightX = smoothstep(0.0, 1.0, uv.x);

	vec4 leftIndicator = hitLeft * color * (1.0 - smoothstep(0.0, 1.0 + addToLength, uv.x));
	vec4 rightIndicator = hitRight * color * smoothstep(0.0, 1.0 - addToLength, uv.x);

	finalColor = leftIndicator + rightIndicator;
}
